//
//  NSDictionaryHelpers.h
//  GlyphsCore
//
//  Created by Georg Seifert on 15.10.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/MGOrderedDictionary.h>

NS_ASSUME_NONNULL_BEGIN

@interface NSDictionary (GetObjectForKeys)
/**
You have to be carful with nil arguments.
*/
- (nullable id)objectForKeys:(id)firstObj, ... NS_REQUIRES_NIL_TERMINATION;

- (nullable id)objectForKeysInArray:(NSArray *)keys;

- (nullable id)objectForKeyPath:(NSString *)keyPath;

- (NSDictionary *)reverseMapping;

- (nullable id)firstKeyForObject:(id)object;

@end

@interface NSMutableDictionary (SetObjectForKeysInArray)

- (void)setObject:(id)inValue forKeysInArray:(NSArray *)keys;

- (nonnull id)objectForKey:(nonnull id)key defaultClass:(nonnull Class)defaultClass;

@end

@interface MGOrderedDictionary (SetObjectOrderedForKeysInArray)

- (void)setObject:(id)inValue forKeysInArray:(NSArray *)keys;

- (nonnull id)objectForKey:(nonnull id)key defaultClass:(nonnull Class)defaultClass;

@end

@interface NSDictionary (deepMutableCopy)

- (NSMutableDictionary *)deepMutableCopy;

@end

@interface NSArray (deepMutableCopy)

- (NSMutableArray *)deepMutableCopy;

@end

NS_ASSUME_NONNULL_END
